import mongoose from "mongoose";
import { BoughtenBoothsModel } from "../models/boughten_booths.js";

/**
 * Get related IDs based on reference type and ID
 * @param {string} ref - Reference type (e.g., 'boughten_booths', 'video_walls')
 * @param {string} ref_id - Reference ID to look up
 * @returns {Promise<Object>} Related IDs object
 */
export async function getRelatedIds(ref, ref_id) {
  try {
    if (ref !== "users" && !mongoose.Types.ObjectId.isValid(ref_id)) {
      throw new Error("Invalid ref_id format");
    }

    // Types that need booth lookup
    const boothRelatedRefs = [
      "video_walls",
      "posters",
      "monitors",
      "stands",
      "agents",
      "boughten_booths",
    ];

    if (boothRelatedRefs.includes(ref)) {
      const booth = await BoughtenBoothsModel.findById(ref_id);
      if (!booth || !booth.exhibition_id) {
        throw new Error(`${ref} not found or missing exhibition_id`);
      }

      return {
        booth_id: booth._id.toString(),
        exhibition_id: booth.exhibition_id.toString(),
      };
    }

    // Simple refs that don't need mapping
    if (["users", "organizations", "exhibitions"].includes(ref)) {
      return {};
    }

    throw new Error(`Invalid ref type: ${ref}`);
  } catch (error) {
    throw new Error(`Failed to get related IDs: ${error.message}`);
  }
}
