/**
 * Create upload tracking object
 * @param {Object} file - File object with originalname and size
 * @returns {Object} Upload tracker object
 */
export function createUploadTracker(file) {
    return {
        startTime: Date.now(),
        fileName: file.originalname,
        fileSize: file.size,
        status: 'processing'
    };
}

/**
 * Update upload tracker with completion status
 * @param {Object} tracker - Upload tracker object
 */
export function completeUploadTracker(tracker) {
    tracker.status = 'completed';
    tracker.endTime = Date.now();
    tracker.processingTime = tracker.endTime - tracker.startTime;
    return tracker;
}