import axios from "axios";
import { smsConfig } from "../config/sms.js";
import { isInt } from "../utils/validation.js";

export const sendVerificationCode = async (phoneNumber, code) => {
  const to = [phoneNumber];
  const input_data = {
    "verification-code": code.toString()
  };
  
  const url = `${smsConfig.baseUrl}?username=${smsConfig.user}&password=${encodeURIComponent(
    smsConfig.password
  )}&from=${smsConfig.phone}&to=${encodeURIComponent(
    JSON.stringify(to)
  )}&input_data=${encodeURIComponent(JSON.stringify(input_data))}&pattern_code=${smsConfig.patternCode}`;

  try {
    const response = await axios.get(url);
    
    if (!isInt(response.data)) {
      return false;
    }
    
    return response.status === 200;
  } catch (error) {
    console.error('SMS service error:', error.message);
    return false;
  }
};