import dotenv from "dotenv";
import { openAI } from "../config/openai.js";

dotenv.config();

export async function translateText(inputText, languages) {
  console.log("Translating text:", inputText);
  console.log("Target languages:", languages);
  const response = await openAI.chat.completions.create({
    model: "gpt-4o",
    max_completion_tokens: 16384,
    messages: [
      {
        role: "system",
        content:
          "Translate the following text into the given languages and return the result as a JSON object.",
      },
      {
        role: "user",
        content: `Translate this text: ${JSON.stringify(inputText)} into the following languages: ${JSON.stringify(languages)} even if the user wrote a wrong sentence or word, correct it yourself`,
      },
    ],
    response_format: {
      type: "json_schema",
      json_schema: {
        name: "language_schema_object_with_array",
        schema: {
          type: "object",
          properties: {
            languages: {
              type: "array",
              items: {
                type: "object",
                properties: {
                  language: {
                    type: "string",
                    description:
                      "The name of the language in its native script.",
                  },
                  iso_code: {
                    type: "string",
                    description:
                      "The ISO code representing the language. Write in capital letters.",
                  },
                  value: {
                    type: "string",
                    description:
                      "The translation of the key in the specified language.",
                  },
                },
                required: ["language", "iso_code", "value"],
                additionalProperties: false,
              },
            },
          },
          required: ["languages"],
          additionalProperties: false,
        },
        strict: true,
      },
    },
  });
  console.log("API response:", response);
  const functionArgs = response.choices[0].message.content;
  const parsedResponse = JSON.parse(functionArgs);
  console.log("Parsed response:", parsedResponse);
  return parsedResponse.languages;
}
