import express from "express";
import upload from "../config/upload.js";

import {
  authenticateJWT,
  authenticateOrigin,
  authenticateUserExist,
  authenticateUserAgent,
} from "../middleware/auth.js";

import { validateFileUpload } from "../middleware/fileValidation.js";
import { uploadFile } from "../controllers/fileController.js";
import { deleteFilesByRefAndBooth } from "../controllers/fileController.js";


const router = express.Router();

/**
 * @swagger
 * /upload:
 *   post:
 *     tags:
 *       - Upload
 *     summary: آپلود فایل
 *     description: آپلود فایل برای موجودیت‌های مختلف (users، posters، agents، ...)
 *     security:
 *       - bearerAuth: []
 *     requestBody:
 *       required: true
 *       content:
 *         multipart/form-data:
 *           schema:
 *             type: object
 *             required:
 *               - file
 *               - ref
 *               - ref_id
 *             properties:
 *               file:
 *                 type: string
 *                 format: binary
 *               ref:
 *                 type: string
 *                 enum: [organizations, users, exhibitions, boughten_booths, video_walls, posters, monitors, stands, agents]
 *               ref_id:
 *                 type: string
 *               category:
 *                 type: string
 *     responses:
 *       201:
 *         description: فایل با موفقیت آپلود شد
 *       400:
 *         description: ورودی نامعتبر
 *       500:
 *         description: خطای سرور
 */
router.post(
  "/",
  authenticateOrigin,
  authenticateUserAgent,
  authenticateJWT,
  authenticateUserExist,
  upload.single("file"),
  validateFileUpload,
  uploadFile
);

/**
 * DELETE /upload
 * حذف فایل‌ها براساس exhibition_id و ref
 */
router.delete(
  "/",
  authenticateOrigin,
  authenticateUserAgent,
  authenticateJWT,
  authenticateUserExist,
  deleteFilesByRefAndBooth
);

export default router;
