// routes/testToken.js

import express from "express";
import { authenticateJWT } from "../middleware/auth.js"; // مسیر درست auth.js رو رعایت کن

const router = express.Router();

/**
 * @route   GET /test-token
 * @desc    بررسی اعتبار توکن JWT
 * @access  Protected (فقط با توکن معتبر قابل دسترسی است)
 */
router.get("/test-token", authenticateJWT, (req, res) => {
    res.status(200).json({
        success: true,
        message: "Token is valid ✅",
        user: req.user,
    });
});


export default router;
