import express from "express";
import { body, validationResult } from "express-validator";
import {
  authenticateOrigin,
  authenticateUserAgent,
  authenticateJWT,
  authenticateUserExist,
  authenticateUserCompletedInformation,
  authenticateCurrency,
} from "../middleware/auth.js";
import { ExhibitionsModel } from "../models/exhibitions.js";
import { ExhibitionsCategoriesModel } from "../models/exhibitions_categories.js";
import { PricesModel } from "../models/prices.js";
import { CurrenciesModel } from "../models/currencies.js";
import authBooth from "../routes/booths.js";

const router = express.Router();

router.get(
  "/",
  authenticateOrigin,
  authenticateUserAgent,
  authenticateJWT,
  authenticateUserExist,
  authenticateUserCompletedInformation,
  authenticateCurrency,
  async (req, res) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({
        data: null,
        ...errors,
        message: "validation error",
      });
    }
    const exhibitions_categories = await ExhibitionsCategoriesModel.find(
      {
        is_removed: false,
      },
      { is_removed: 0 }
    );
    const exhibitions = await ExhibitionsModel.find(
      { is_removed: false },
      { is_removed: 0 }
    );
    var pricesr = [];
    for (let index = 0; index < exhibitions.length; index++) {
      const exhibition = exhibitions[index];
      const prices = await PricesModel.findOne({
        ref: "exhibitions",
        ref_id: exhibition._id,
        currency_id: req.currency._id,
        is_removed: false,
      });
      const currency = await CurrenciesModel.findById(req.currency._id);
      pricesr[index] = { price: prices, currency: currency };

      exhibitions[index] = {
        ...exhibition.toObject(),
        price_per_year: pricesr[index],
      };
    }
    res.status(200).json({
      data: {
        categories: exhibitions_categories ? exhibitions_categories : [],
        exhibitions: exhibitions ? exhibitions : [],
      },
    });
  }
);


router.get(
  "/tutorial",
  authenticateOrigin,
  authenticateUserAgent,
  authenticateJWT,
  authenticateUserExist,
  authenticateUserCompletedInformation,
  async (req, res) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({
        data: null,
        ...errors,
        message: "validation error",
      });
    }
    res.status(200).json({
      data: {
        title: "exhibitions_title_key",
        description: "exhibitions_description_key",
        banner_link: "",
        video_link: "",
      },
    });
  }
);
router.post(
  "/get-by-id",
  authenticateOrigin,
  authenticateUserAgent,
  authenticateJWT,
  authenticateUserExist,
  authenticateUserCompletedInformation,
  authenticateCurrency,
  body("id").isMongoId().withMessage("Invalid exhibition ID"),
  async (req, res) => {
    const errors = validationResult(req);
    if (!errors.isEmpty()) {
      return res.status(400).json({
        data: null,
        errors: errors.array(),
        message: "Validation error",
      });
    }

    const { id } = req.body;

    try {
      const exhibition = await ExhibitionsModel.findOne({
        _id: id,
        is_removed: false,
      }).lean();

      if (!exhibition) {
        return res.status(404).json({
          data: null,
          message: "Exhibition not found",
        });
      }

      const price = await PricesModel.findOne({
        ref: "exhibitions",
        ref_id: exhibition._id,
        currency_id: req.currency._id,
        is_removed: false,
      });

      const currency = await CurrenciesModel.findById(req.currency._id);

      return res.status(200).json({
        data: {
          ...exhibition,
          price_per_year: {
            price,
            currency,
          },
        },
        message: "Exhibition fetched successfully",
      });
    } catch (err) {
      console.error("❌ Error:", err);
      return res.status(500).json({
        data: null,
        message: "Internal server error",
      });
    }
  }
);
console.log("wkow")

router.use("/booths", authBooth);
export default router;
