import express from "express";
import {
  authenticateOrigin,
  authenticateUserAgent,
} from "../middleware/auth.js";
import { CurrenciesModel } from "../models/currencies.js";

const router = express.Router();

router.get("/", authenticateOrigin, authenticateUserAgent, async (req, res) => {
  try {
    const currencies = await CurrenciesModel.find({ is_removed: false });

    const protocol = req.protocol;
    const host = req.headers.host;

    const data = currencies.map((currency) => {
      const c = currency.toObject();

      const iconStr = c.icon ? c.icon.toString() : null;

      const fileName =
        typeof iconStr === "string"
          ? iconStr.endsWith(".ico")
            ? iconStr
            : iconStr + ".ico"
          : null;

      c.icon_url = fileName ? `${protocol}://${host}/icons/${fileName}` : null;

      return c;
    });

    return res.status(200).json({
      data,
      message: "Currencies fetched successfully",
    });
  } catch (error) {
    return res.status(500).json({
      data: null,
      message: "Server error",
      error: error.message,
    });
  }
});

export default router;
