import mongoose from "mongoose";

const PricesSchema = new mongoose.Schema(
  {
    ref: {
      type: String,
      required: true,
    },
    ref_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
    },
    title: {
      type: String,
      required: true,
    },
    price: {
      type: Number,
      required: true,
    },
    currency_id: {
      type: mongoose.Schema.Types.ObjectId,
    },
    duration: {
      type: Number,
      required: true,
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

export const PricesModel = mongoose.model("prices", PricesSchema);
