import mongoose from "mongoose";

const languageModelSchema = new mongoose.Schema({
  language: {
    type: String,
    required: true,
  },
  iso_code: {
    type: String,
    required: true,
  },
  country: {
    type: String,
  },
  direction: {
    type: String,
  },
  sentences: {
    type: Object,
    required: true,
    default: {},
  },
  is_removed: { type: Boolean, required: true, default: false },
});

export const LanguageModel = mongoose.model("languages", languageModelSchema);
