import mongoose from "mongoose";

const FileSchema = new mongoose.Schema(
  {
    ref: {
      type: String,
      required: true,
      enum: [
        "organizations",
        "users",
        "exhibitions",
        "boughten_booths",
        "video_walls",
        "posters",
        "monitors",
        "logo",
        "stands",
        "agents",
        "setting"
      ],
    },
    ref_id: {
      type: mongoose.Schema.Types.ObjectId,
      required: true,
    },
    url: {
      type: String,
      required: true,
    },
    type: {
      type: String,
      required: true,
    },
    size: {
      type: Number,
      required: true,
    },
    private: {
      type: Boolean,
      required: true,
      default: false,
    },
    is_removed: {
      type: Boolean,
      required: true,
      default: false,
    },
  },
  {
    timestamps: true,
  }
);

FileSchema.index({ ref: 1, ref_id: 1 });

export const FileModel = mongoose.model("files", FileSchema);

export default FileModel;

