import mongoose from "mongoose";

const CodeVerifySchema = new mongoose.Schema(
  {
    phone: {
      type: String,
      required: true,
    },
    code: {
      type: Number,
      required: true,
    },
  },
  {
    timestamps: true,
  }
);

// Add index to automatically expire documents after 2 minutes
CodeVerifySchema.index({ createdAt: 1 }, { expireAfterSeconds: 120 });

export const CodeVerifyModel = mongoose.model(
  "code_verifies",
  CodeVerifySchema
);
