import { validationResult } from "express-validator";

export const validate = (req, res, next) => {
  const errors = validationResult(req);
  if (!errors.isEmpty()) {
    return res.status(400).json({
      data: null,
      ...errors,
      message: "validation error"
    });
  }
  next();
};

// Validation chains for reusable validation rules
export const phoneValidation = {
  phone: (field = "phone") => ({
    in: ["body"],
    custom: {
      options: (value) => {
        const iranianMobilePhonePattern = /^(\+98|0)?9\d{9}$/;
        if (!iranianMobilePhonePattern.test(value)) {
          throw new Error("شماره تلفن معتبر نیست");
        }
        return true;
      }
    },
    notEmpty: {
      errorMessage: "شماره تلفن نمی‌تواند خالی باشد"
    },
    trim: true,
    escape: true
  })
};

export const codeValidation = {
  code: (field = "code") => ({
    in: ["body"],
    isNumeric: {
      errorMessage: "کد ورود معتبر نیست"
    },
    notEmpty: {
      errorMessage: "کد ورود نمی‌تواند خالی باشد"
    },
    trim: true,
    escape: true
  })
};