import { RateLimitModel } from "../models/rateLimit.js";

export const rateLimiter = async (req, res, next) => {
  try {
    const ip = req.ip;
    let rateLimit = await RateLimitModel.findOne({ ip });

    if (rateLimit) {
      if (rateLimit.requests >= 1000) {
        return res.status(429).json({
          data: null,
          message: "Too many requests. Please try again later.",
        });
      }
      rateLimit.requests++;
      await rateLimit.save();
    } else {
      await RateLimitModel.create({ ip });
    }

    next();
  } catch (error) {
    console.error("Rate limit error:", error);
    res.status(500).json({
      data: null,
      message: "Server error.",
    });
  }
};
