// src/services/fileService.js
import fs from 'fs/promises';
import path from 'path';
import FileModel from '../models/file.js';

const UPLOAD_ROOT = path.join(process.cwd(), 'uploads');

export async function deleteFilesByOwnerAndRef(owner_id, ref) {
  // حذف از دیتابیس
  const result = await FileModel.deleteMany({ owner_id, ref });

  // حذف فایل‌های فیزیکی از فولدر (اگر لازم)
  const dir = path.join(UPLOAD_ROOT, ref);
  try {
    const files = await fs.readdir(dir);
    for (const file of files) {
      await fs.unlink(path.join(dir, file));
    }
  } catch (e) {
    // اگر فولدر یا فایل نبود مشکلی نیست
  }

  return result.deletedCount;
}
