export const InvoiceSwaggerDocs = {
    "/invoices": {
        post: {
            tags: ["Invoices"],
            summary: "Create a new invoice",
            description: "Adds a new invoice to the system.",
            security: [{ BearerAuth: [] }],
            requestBody: {
                required: true,
                content: {
                    "application/json": {
                        schema: {
                            type: "object",
                            required: ["ref", "ref_id", "payment_method_id", "amount"],
                            properties: {
                                ref: { type: "string", example: "boughten_booths" },
                                ref_id: { type: "string", example: "663f26be388558fbd67f13a5" },
                                payment_method_id: { type: "string", example: "663f26be388558fbd67f13a7" },
                                amount: { type: "number", example: 120000 },
                                discount: { type: "number", example: 10000 },
                                tax: { type: "number", example: 9000 },
                            },
                        },
                    },
                },
            },
            responses: {
                201: {
                    description: "Invoice created successfully",
                    content: {
                        "application/json": {
                            schema: {
                                type: "object",
                                properties: {
                                    data: { type: "object" },
                                    message: { type: "string", example: "Invoice created successfully" },
                                },
                            },
                        },
                    },
                },
                400: { $ref: "#/components/responses/BadRequest" },
                500: { $ref: "#/components/responses/ServerError" },
            },
        },

        get: {
            tags: ["Invoices"],
            summary: "Get all invoices",
            description: "Returns a list of invoices. You can use `ref=all` to get all invoices or specify a specific ref to filter.",
            security: [{ BearerAuth: [] }],
            parameters: [
                {
                    in: "query",
                    name: "ref",
                    schema: { type: "string" },
                    required: false,
                    description: "Filter by invoice ref (e.g. 'boughten_booths') or use 'all' to get all invoices.",
                    example: "all",
                },
            ],
            responses: {
                200: {
                    description: "A list of invoices",
                    content: {
                        "application/json": {
                            schema: {
                                type: "object",
                                properties: {
                                    data: {
                                        type: "array",
                                        items: { type: "object" },
                                    },
                                    message: {
                                        type: "string",
                                        example: "invoices fetched successfully",
                                    },
                                },
                            },
                        },
                    },
                },
                500: { $ref: "#/components/responses/ServerError" },
            },
        },
    },
};
