import { MeetingModel } from '../models/meeting.js';
import { BoughtenBoothsModel } from '../models/boughten_booths.js';

export const bookMeeting = async (req, res) => {
    const { booth_id, start_time, end_time } = req.body;
    const userId = req.user.id; // از JWT می‌آید، پس حتما authenticateJWT استفاده شده

    try {
        // پیدا کردن بوت و اعتبارسنجی مالکیت
        const booth = await BoughtenBoothsModel.findById(booth_id);
        if (!booth) {
            return res.status(404).json({ message: 'Booth not found' });
        }
        if (booth.owner_id.toString() !== userId.toString()) {
            return res.status(403).json({ message: 'You are not allowed to book meetings for this booth' });
        }

        // چک کردن تداخل زمانی جلسه‌ها
        const conflictingMeeting = await MeetingModel.findOne({
            booth_id,
            $or: [
                { start_time: { $lt: new Date(end_time), $gte: new Date(start_time) } },
                { end_time: { $gt: new Date(start_time), $lte: new Date(end_time) } },
                { start_time: { $lte: new Date(start_time) }, end_time: { $gte: new Date(end_time) } }
            ]
        });

        if (conflictingMeeting) {
            return res.status(409).json({ message: 'Time slot is already booked' });
        }

        // ذخیره جلسه جدید
        const newMeeting = new MeetingModel({
            booth_id,
            start_time: new Date(start_time),
            end_time: new Date(end_time)
        });

        await newMeeting.save();

        return res.status(201).json({ message: 'Meeting booked successfully', meeting: newMeeting });
    } catch (error) {
        console.error(error);
        return res.status(500).json({ message: 'Internal server error' });
    }
};
