import { calculateTokens } from '../utils/chatHelpers.js';

// Test different scenarios
const text = "Hello, world! This is a test message.";
console.log('Test text:', text);
console.log('GPT-3.5 Tokens:', calculateTokens(text, 'gpt-3.5-turbo'));
console.log('GPT-4 Tokens:', calculateTokens(text, 'gpt-4'));

// Test longer text
const longText = "This is a much longer piece of text that should generate more tokens. " +
                "It contains multiple sentences and some numbers like 12345. " +
                "Special characters !@#$% and emojis 😀 might affect token count differently.";
console.log('\nLong test:', longText);
console.log('GPT-3.5 Tokens:', calculateTokens(longText, 'gpt-3.5-turbo'));
console.log('GPT-4 Tokens:', calculateTokens(longText, 'gpt-4'));

// Test edge cases
console.log('\nEdge cases:');
console.log('Empty string:', calculateTokens(''));
console.log('Null:', calculateTokens(null));
console.log('Number:', calculateTokens(12345));