import os
import pandas as pd
import arabic_reshaper
from bidi.algorithm import get_display

def test_excel_processing():
    # Use absolute path from project root with Windows path separators
    excel_path = r"e:\projects\metaboard_backend\src\test\raw_file\مشخصات شرکت آرین تل-14031015.xlsx"
    
    try:
        if not os.path.exists(excel_path):
            print(f"File not found: {excel_path}")
            return False
            
        print(f"Testing Excel processing for: {excel_path}")
        print("-" * 50)
        
        # Read Excel file
        print("Reading Excel file...")
        df = pd.read_excel(excel_path)
        
        print("\nColumns:", df.columns.tolist())
        print("\nFirst few rows:")
        print(df.head())
        
        # Process Persian text
        print("\nProcessing Persian text...")
        
        # Handle column names
        rtl_columns = []
        for col in df.columns:
            reshaped = arabic_reshaper.reshape(str(col))
            rtl_text = get_display(reshaped)
            rtl_columns.append(rtl_text)
            
        print("\nRTL Column Names:")
        print(rtl_columns)
            
        return True
    except Exception as e:
        print(f"Error: {str(e)}")
        return False

if __name__ == "__main__":
    success = test_excel_processing()
    print(f"\nTest {'succeeded' if success else 'failed'}")