/**
 * Creates a vector store for file search
 */
export async function createVectorStore(config, client, withRetry, maxRetries, retryDelay) {
    return await withRetry(async () => {
        const vector_store = await client.beta.vectorStores.create({
            name: config.name,
            expires_after: config.expiration_policy
        });
        return vector_store;
    }, maxRetries, retryDelay);
}

/**
 * Adds processed files to a vector store
 */
export async function addFilesToVectorStore(vector_store_id, file_ids, client, withRetry, maxRetries, retryDelay) {
    return await withRetry(async () => {
        const batch = await client.beta.vectorStores.fileBatches.createAndPoll(
            vector_store_id,
            { file_ids: file_ids }
        );
        return batch;
    }, maxRetries, retryDelay);
}