/**
 * Utility method to implement retry logic
 * @private
 */
export async function withRetry(operation, maxRetries, retryDelay) {
    let last_error;
    for (let attempt = 1; attempt <= maxRetries; attempt++) {
        try {
            return await operation();
        } catch (error) {
            last_error = error;
            if (attempt === maxRetries) break;

            const delay = retryDelay * attempt;
            await new Promise(resolve => setTimeout(resolve, delay));

            console.warn(`Retry attempt ${attempt} after error: ${error.message}`);
        }
    }
    throw last_error;
}