import rateLimit from 'express-rate-limit';

// Rate limiter for audio transcription
export const transcriptionLimiter = rateLimit({
  windowMs: 15 * 60 * 1000, // 15 minutes
  max: 50, // Limit each IP to 50 transcription requests per window
  message: {
    success: false,
    error: 'Too many transcription requests. Please try again later.'
  }
});

// Rate limiter for text-to-speech
export const synthesisLimiter = rateLimit({
  windowMs: 15 * 60 * 1000, // 15 minutes
  max: 100, // Limit each IP to 100 synthesis requests per window
  message: {
    success: false,
    error: 'Too many speech synthesis requests. Please try again later.'
  }
});