export const AgentSwaggerDocs = {
    '/agent/create': {
        post: {
            tags: ['AI Pipeline'],
            summary: 'Create a new agent',
            description: 'Creates a new agent with specified configuration',
            requestBody: {
                required: true,
                content: {
                    'application/json': {
                        schema: {
                            type: 'object',
                            required: ['name', 'brand_guidelines', 'available_topics', 'ref', 'ref_id'],
                            properties: {
                                name: { type: 'string' },
                                brand_guidelines: { type: 'string' },
                                available_topics: {
                                    type: 'array',
                                    items: { type: 'string' }
                                },
                                ref: {
                                    type: 'string',
                                    enum: ['boughten_booths']
                                },
                                ref_id: { type: 'string' }
                            }
                        }
                    }
                }
            },
            responses: {
                201: {
                    description: 'Agent created successfully',
                    content: {
                        'application/json': {
                            schema: {
                                type: 'object',
                                properties: {
                                    agent_id: { type: 'string' }
                                }
                            }
                        }
                    }
                },
                400: {
                    $ref: '#/components/responses/BadRequest'
                },
                500: {
                    $ref: '#/components/responses/ServerError'
                }
            }
        }
    },
    '/agent/{agent_id}/build': {
        post: {
            tags: ['AI Pipeline'],
            summary: 'Process agent\'s documents',
            parameters: [{
                in: 'path',
                name: 'agent_id',
                required: true,
                schema: { type: 'string' }
            }],
            responses: {
                202: {
                    description: 'Processing started',
                    content: {
                        'application/json': {
                            schema: {
                                type: 'object',
                                properties: {
                                    agent_id: { type: 'string' },
                                    status: {
                                        type: 'string',
                                        enum: ['processing']
                                    },
                                    total_files: { type: 'number' },
                                    processed: { type: 'number' },
                                    failed: { type: 'number' }
                                }
                            }
                        }
                    }
                },
                404: {
                    $ref: '#/components/responses/NotFound'
                },
                500: {
                    $ref: '#/components/responses/ServerError'
                }
            }
        }
    },
    '/agent/{agent_id}/queue-status': {
        get: {
            tags: ['AI Pipeline'],
            summary: 'Get processing status',
            parameters: [{
                in: 'path',
                name: 'agent_id',
                required: true,
                schema: { type: 'string' }
            }],
            responses: {
                200: {
                    description: 'Status retrieved successfully',
                    content: {
                        'application/json': {
                            schema: {
                                type: 'object',
                                properties: {
                                    queue_status: {
                                        type: 'string',
                                        enum: ['queued', 'processing', 'completed', 'failed', 'not_found']
                                    },
                                    queue_position: { type: 'number' },
                                    progress: { type: 'number' },
                                    estimated_completion_time: {
                                        type: 'string',
                                        format: 'date-time'
                                    },
                                    error: { type: 'string' }
                                }
                            }
                        }
                    }
                },
                404: {
                    $ref: '#/components/responses/NotFound'
                },
                500: {
                    $ref: '#/components/responses/ServerError'
                }
            }
        }
    }
};
