import fs from 'fs/promises';
import path from 'path';

export class TimeEstimator {
    /**
     * Calculate estimated completion time based on file size and type
     */
    async calculateEstimatedTime(inputDir) {
        const files = await fs.readdir(inputDir);
        let totalEstimatedSeconds = 0;

        for (const file of files) {
            const stats = await fs.stat(path.join(inputDir, file));
            // Base estimate: 1 second per 100KB + 5 seconds base processing time
            const sizeEstimate = Math.ceil(stats.size / 102400);
            const baseEstimate = 5;
            totalEstimatedSeconds += sizeEstimate + baseEstimate;
        }

        // Add 10% buffer
        totalEstimatedSeconds = Math.ceil(totalEstimatedSeconds * 1.1);
        return new Date(Date.now() + (totalEstimatedSeconds * 1000));
    }
}