import axios from "axios";
import fs from "fs";
import FormData from "form-data";

const sendFileToServer = async (localFilePath, ref, ref_id) => {
    const form = new FormData();
    form.append("file", fs.createReadStream(localFilePath));
    form.append("ref", ref);
    form.append("ref_id", ref_id);

    try {
        const res = await axios.post("http://192.168.10.50:6015/upload", form, {
            headers: form.getHeaders(),
        });

        console.log("✅ Response from server:", res.data);
    } catch (err) {
        console.error("❌ Error uploading file:", err.response?.data || err.message);
    }
};

// مثال استفاده:
sendFileToServer("./uploads/test.png", "posters", "67a73272e6935b66a4603c94");
