import os
import time
import logging
import traceback
import base64
import secrets
import json
from flask import Flask, request, jsonify
from flask_cors import CORS
from openai import OpenAI
from logging.handlers import RotatingFileHandler
from collections import defaultdict
from difflib import SequenceMatcher

log_dir = "logs"
os.makedirs(log_dir, exist_ok=True)
log_file_path = os.path.join(log_dir, "app.log")

handler = RotatingFileHandler(log_file_path, maxBytes=10 * 1024 * 1024, backupCount=5)
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter("%(asctime)s - %(levelname)s - %(message)s")
handler.setFormatter(formatter)
logging.getLogger().addHandler(handler)

console_handler = logging.StreamHandler()
console_handler.setLevel(logging.DEBUG)
console_handler.setFormatter(formatter)
logging.getLogger().addHandler(console_handler)

app = Flask(__name__)
CORS(app, resources={r"/*": {"origins": "*"}})

OPENAI_API_KEY = "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"
user_memory = defaultdict(dict)


def load_knowledge_base():
    try:
        with open("finally.json", "r", encoding="utf-8") as f:
            return json.load(f)
    except FileNotFoundError:
        logging.error("finally.json file not found")
        return []
    except json.JSONDecodeError:
        logging.error("Error decoding finally.json")
        return []


def similarity(a, b):
    return SequenceMatcher(None, a, b).ratio()


def find_best_match(user_query, knowledge_base, threshold=0.7):
    best_match = None
    best_score = 0
    user_query_lower = user_query.lower().strip()
    for item in knowledge_base:
        prompts_to_check = [
            item.get("prompt_fa", ""),
            item.get("prompt_en", ""),
            item.get("prompt_tr", ""),
            item.get("prompt_ar", ""),
        ]
        for prompt in prompts_to_check:
            if prompt:
                score = similarity(user_query_lower, prompt.lower().strip())
                if score > best_score and score >= threshold:
                    best_score = score
                    best_match = item
    return best_match, best_score


@app.route("/complete", methods=["POST"])
def complete():
    logging.info("🚀 /complete endpoint called")

    if not OPENAI_API_KEY:
        return jsonify({"error": "API key not set in environment variables"}), 500

    client = OpenAI(api_key=OPENAI_API_KEY)

    user_message = request.form.get("user_query")
    audio_file = request.files.get("audio")
    client_type = request.form.get("client_type", "general")
    selected_lang = request.form.get("lang", "fa-IR")
    user_id = request.remote_addr

    if (user_message is None and audio_file is None) or (user_message and audio_file):
        return (
            jsonify(
                {"error": "Please send EITHER user_query OR upload an audio file."}
            ),
            400,
        )

    knowledge_base = load_knowledge_base()

    if client_type == "app1":
        if selected_lang.startswith("fa"):
            selected_prompt = (
                "شما یک دستیار هوش مصنوعی رسمی و چندزبانه به نام دکتر مهرداد فُجلَلی هستید که نماینده مرکز توسعه کسب‌وکار وان می‌باشید.\n"
                "✅ پاسخ‌هات رو همیشه با این جمله شروع کن:\n"
                "من دکتر مهرداد فُجلَلی، دستیار هوش مصنوعی مرکز توسعه کسب‌وکار وان هستم.\n"
                "✅ فقط درباره مرکز کارآفرینی وان، اکوسیستم نوآوری، یا سازمان‌های مرتبط مانند Trvanexport، Dinar Holding، Turcaba، ASRAID، و OMPP-WOFP پاسخ بده.\n"
                "⛔ اگر سؤال خارج از این موضوعات بود، بگو: «من فقط درباره مرکز کارآفرینی وان و سازمان‌های مرتبط پاسخ می‌دم.»\n"
                "✅ تمام پاسخ‌ها باید فقط و فقط به زبان فارسی رسمی باشند."
            )
        elif selected_lang.startswith("en"):
            selected_prompt = (
                "You are an official multilingual AI assistant named Dr. Mehrdad Fojlaley, representing the Van Business Development Center.\n"
                "✅ Always begin your response with this statement:\n"
                "I am Dr. Mehrdad Fojlaley, the AI assistant of Van Business Development Center.\n"
                "✅ Only answer questions related to the Van Entrepreneurship Center, its innovation ecosystem, or affiliated organizations such as Trvanexport, Dinar Holding, Turcaba, ASRAID, and OMPP-WOFP.\n"
                "⛔ If the question is outside these topics, say: “I'm only able to answer questions related to the Van Entrepreneurship Center or affiliated organizations.”\n"
                "✅ All responses must be in clear, formal English only."
            )
        elif selected_lang.startswith("tr"):
            selected_prompt = (
                "Resmî, çok dilli bir yapay zekâ asistanısınız, adınız Dr. Mehrdad FOJLALEY ve Van İş Geliştirme Merkezi'ni temsil ediyorsunuz.\n"
                "✅ Cevaplarınıza şu ifadeyle başlayın:\n"
                "Ben Dr. Mehrdad FOJLALEY, Van İş Geliştirme Merkezi’nin danışmanı yapay zekâ asistanıyım.\n"
                "✅ SADECE Van Girişimcilik Merkezi, yenilik ekosistemi veya Trvanexport, Dinar Holding, Turcaba, ASRAID ve OMPP-WOFP ile ilgili sorulara cevap verin.\n"
                "⛔ Farklı konular için: “Sadece Van Girişimcilik Merkezi veya ilgili kuruluşlarla ilgili sorulara cevap verebilirim.” deyin.\n"
                "✅ Tüm cevaplarınız SADECE resmi, net Türkçe olmalıdır."
            )
        elif selected_lang.startswith("ar"):
            selected_prompt = (
                "أنت مساعد ذكاء اصطناعي رسمي ومتعدد اللغات يُدعى د. مهرداد فُجلَلي وتمثل مركز تطوير الأعمال في فان.\n"
                "✅ ابدأ ردك دائمًا بهذه العبارة:\n"
                "أنا الدكتور مهرداد فُجلَلي، مساعد الذكاء الاصطناعي لمركز تطوير الأعمال في فان.\n"
                "✅ أجب فقط عن الأسئلة المتعلقة بمركز ريادة الأعمال في فان أو النظام البيئي للابتكار أو المنظمات التابعة مثل Trvanexport و Dinar Holding و Turcaba و ASRAID و OMPP-WOFP.\n"
                "⛔ إذا كان السؤال خارج هذه المواضيع، قل: “أستطيع فقط الرد على الأسئلة المتعلقة بمركز ريادة الأعمال في فان أو المنظمات التابعة له.”\n"
                "✅ يجب أن تكون جميع الإجابات باللغة العربية الفصحى فقط."
            )
        else:
            selected_prompt = "You are an AI assistant. Use polite, formal, and clear responses. Default to English."

        prompt_type = "app1"

    elif client_type == "app2":
        selected_prompt = (
            "You are Webcom, the official AI assistant for Atabi Tower — a cutting-edge metaverse platform.\n"
            "✅ You must ONLY respond to questions related to Atabi Tower.\n"
            "✅ Always answer in both English and Turkish.\n"
            "⛔ Do not answer any general or unrelated questions.\n"
            "✅ Use a formal, informative tone.\n\n"
            "📍 About Atabi Tower:\n"
            "Atabi Tower is a cross-platform metaverse environment with multiple 3D interactive floors including Conference, Seminar, Expo, Office, and Innovation Hall.\n"
            "It supports Windows, Android, and VR devices.\n\n"
            "- Multi-mode navigation (free walk, teleport, interactive map)\n"
            "- Real-time interaction with text/voice\n"
            "- AI agents for guidance, explanations, and booth management\n"
            "- Fully optimized for various devices\n"
            "- Metaboard dashboard for booth/office management, content upload, and AI integration\n\n"
            'If they ask something else, respond: "I\'m only able to assist with topics related to Atabi Tower. Please ask a related question."\n'
        )
        prompt_type = "app2"
    else:
        selected_prompt = (
            "شما هوش ع هستید.\n"
            "✅ مودب، دقیق و رسمی صحبت کن. پاسخ‌ها باید فارسی رسمی باشند.\n"
        )
        prompt_type = "general"

    # ادامه‌ی کد بدون تغییر باقی می‌ماند.

    try:
        if user_message:
            if "شماره من" in user_message and any(
                char.isdigit() for char in user_message
            ):
                user_memory[user_id]["phone"] = user_message
            elif "شماره من یادت هست" in user_message or "شماره‌مو یادته" in user_message:
                remembered = user_memory[user_id].get("phone")
                if remembered:
                    return (
                        jsonify(
                            {
                                "text": f"بله عزیزم، شما گفته بودید: {remembered}",
                                "audio": None,
                                "prompt_type": prompt_type,
                            }
                        ),
                        200,
                    )
                else:
                    return (
                        jsonify(
                            {
                                "text": "نه عزیز دلم، هنوز شماره‌ای بهم ندادی.",
                                "audio": None,
                                "prompt_type": prompt_type,
                            }
                        ),
                        200,
                    )

            best_match, score = find_best_match(user_message, knowledge_base)
            if best_match and score > 0.7:
                logging.info(f"Found match in knowledge base with score: {score}")
                response_text = best_match.get("response_fa", "")
                if response_text:
                    return (
                        jsonify(
                            {
                                "text": response_text,
                                "audio": None,
                                "prompt_type": prompt_type,
                            }
                        ),
                        200,
                    )

        messages = [{"role": "system", "content": selected_prompt}]
        if user_message:
            messages.append({"role": "user", "content": user_message})
        elif audio_file:
            audio_bytes = audio_file.read()
            encoded_audio = base64.b64encode(audio_bytes).decode("utf-8")
            audio_format = (
                os.path.splitext(audio_file.filename)[1].replace(".", "") or "mp3"
            )
            messages.append(
                {
                    "role": "user",
                    "content": [
                        {"type": "text", "text": "Process the following audio input."},
                        {
                            "type": "input_audio",
                            "input_audio": {
                                "data": encoded_audio,
                                "format": audio_format,
                            },
                        },
                    ],
                }
            )

        completion = client.chat.completions.create(
            model="gpt-4o-audio-preview",
            modalities=["text", "audio"],
            audio={"voice": "ash", "format": "mp3"},
            messages=messages,
        )

        audio_data_b64 = None
        text_transcript = None

        if completion.choices and completion.choices[0].message:
            msg = completion.choices[0].message
            audio_obj = getattr(msg, "audio", None)
            if audio_obj:
                audio_data_b64 = getattr(audio_obj, "data", None)
                text_transcript = getattr(audio_obj, "transcript", None)
            if not text_transcript:
                text_transcript = msg.content or "[متنی دریافت نشد]"

        if audio_data_b64:
            mp3_bytes = base64.b64decode(audio_data_b64)
            filename = secrets.token_hex(20) + ".mp3"
            save_dir = "/home/webcomap/cdn.webcomapipy.ir/3DAiAgent/"
            os.makedirs(save_dir, exist_ok=True)
            save_path = os.path.join(save_dir, filename)

            with open(save_path, "wb") as f:
                f.write(mp3_bytes)

            time.sleep(0.7)
            audio_url = f"https://cdn.webcomapipy.ir/3DAiAgent/{filename}"

            return (
                jsonify(
                    {
                        "text": text_transcript,
                        "audio": audio_url,
                        "prompt_type": prompt_type,
                    }
                ),
                200,
            )
        else:
            return (
                jsonify(
                    {"text": text_transcript, "audio": None, "prompt_type": prompt_type}
                ),
                200,
            )

    except Exception as e:
        logging.error(f"🔥 Error in /complete: {e}")
        logging.error(traceback.format_exc())
        return jsonify({"error": f"Internal server error: {str(e)}"}), 500


@app.route("/health", methods=["GET"])
def health_check():
    return "OK", 200


if __name__ == "__main__":
    logging.info("Starting Flask app...")
    app.run(host="0.0.0.0", port=8081, debug=True)
